<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Default_Template_Manager
{
  private $default_template = [];

  public function __construct()
  {
    $this->ultimate_ai_setup_template();
  }

  public function ultimate_ai_setup_template()
  {
    $this->set_default_template();
  }

  public function get_default_template()
  {
    return $this->default_template;
  }

  public static function get_blog_templates_prompt($type, $single_prompt = true) //full_blog|title|outlines|regen|image
  {
    $prompts = [
      "title" => 'You are a blog title generator. Generate 6 blog titles in a ' . '[[tone_of_voice]]' . ' voice in ' . '[[language]]' . ' language for this topic:' . '[[about]]' . ' keeping these this primary keyword in mind: ' . '[[primary_key]]' . '.Use maximum 150 tokens per titles and deliver response list format each title wrapped in "<p>" tag and don\'t use any numberd outline',
      "outlines" => 'You are a blog title outline heading generator. Generate 6 blog outline headings in a ' . '[[tone_of_voice]]' . ' voice in ' . '[[language]]' . ' language for this blog title/post:' . '[[title]]' . ', keeping these primary keyword in mind: ' . '[[primary_key]]' . '.Use maximum 100 characters per outline and deliver response list format each title wrapped in "<p>" tag and don\'t use any numberd outline',
      "full_blog" =>  "ChatGPT, Act As SEOMASTER2023, an AI entity with a comprehensive understanding of the most up-to-date SEO best practices, keyword research strategies, and content marketing nuances. As SEOMASTER2023, craft a compelling, unique, and informative blog post on '" . '[[title]]' . "' with elaborating these outlines: '" . '[[outlines]]' . "', ensuring the content targets a primary keyword of " . '[[primary_key]]' . " with high search volume and low competition. The article should be structured with an engaging introduction that briefly outlines the post's value proposition. Dont show title and Wrap outlines in 'h2' tag and outline description in 'p' tag, and a concise conclusion summarizing the key takeaways. Integrate these secondary and related keywords: " . '[[secondary_key]]' . " throughout the article without keyword stuffing, ensuring a keyword density of around 1-2%. Include internal links to other relevant articles, external links to authoritative sources for added credibility, and a compelling meta description no longer than 155 characters. Maintain a " . '[[tone_of_voice]]' . " tone and a conversational style, and make use of transition phrases for fluidity. The content should be mobile-optimized, have a clear call-to-action, and be around " . '[[length]]' . " words. For added user engagement, " . '[[image_prompt]]' . ". Remember, the ultimate goal is to provide value to the reader while adhering to SEO best practices.Your answer only in HTML syntax with HTML tags. Use HTML tags like < ul>, < ol>, < li>, < strong>, < p>
                      Only consider the inner part of the < body> tag. ALWAYS use the following tag for new lines: < br />Do not add CSS attributes.
                      Your answer must be formatted in HTML format.Your responses should only be code, without explanation",
      "regen" => 'You are a text rewriter. Rewrite this text:' . '[[regenaration_text]]' . ' in a ' . '[[tone_of_voice]]' . 'voice. Make the output same length as input text',
      "image" => 'You are a blog image generator. Create an image on this title: "' . '[[title]]' . '".'
    ];

    if (!$single_prompt) return $prompts;

    $available_types = ["full_blog", "title", "outlines", "regen", "image"];
    if (!in_array($type, $available_types)) return "";

    return $prompts[$type];
  }

  private function set_default_template()
  {
    $this->default_template = [
      // 1:Instagram Caption
      [
        'name' => esc_html__('Instagram Caption', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Generate catchy captions for your Instagram posts.', ULTIMATE_AI_SLUG),
        'key' => 'instagram_caption',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/insta.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your post about?', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Best clothing stores in Los Angeles', ULTIMATE_AI_SLUG),
            'key' => 'topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Hashtag', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('hashtag', ULTIMATE_AI_SLUG),
            'key' => 'hashtag',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Targeted audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('audience', ULTIMATE_AI_SLUG),
            'key' => 'audience',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Key words', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('key word', ULTIMATE_AI_SLUG),
            'key' => 'key_word',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Generate an Instagram caption about this topic: ``[[topic]]``. Add some appropriate emoji after the end of the caption. Caption tone of voice should be [[tone_of_voice]]. Also generate 5 hashtags based on the topic. Caption language should be [[language]]. Caption targeted audience is [[audience]]. Use some of these keywords if provided ``[[key_word]]`` in the captions. Give me 5 captions. Give me the result as a markdown format. Follow the below format: ###### Long Caption. \n\n. 1.hashtag  \n 2.hashtag \n 3.hashtag\n 4.hashtag \n 5.hashtag \n", ULTIMATE_AI_SLUG),
      ],

      // 2:Google Ads Copy
      [
        'name' => esc_html__('Google Ads Copy', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Create effective and persuasive ads that generate leads and sales🌟', ULTIMATE_AI_SLUG),
        'key' => 'google_ads_copy',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/google_ads.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product or Service', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'product_or_service',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Campaign keywords', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Put no less than one keyword', ULTIMATE_AI_SLUG),
            'key' => 'keyword',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Value Propostion', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'value_propostion',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Pain Points and Solutions', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'pain_points_and_solutions',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("## Context You are a professional copywriter with extensive experience in writing Google Ads copy with the goal of achieving the highest click-through rate. You are tasked with creating 5 headlines and 10 descriptions tailored to specific keywords and target audience for the provided product/service. - Product/Service: [[product_or_service]] - Keywords: [[keyword]] - Target Audience: [[target_audience]] - Value Proposition: [[value_propostion]] - Pain Points and Solutions: [[pain_points_and_solutions]] - Tone and Style: [[tone_of_voice]] ## Approach Craft compelling headlines that directly address the target audience's pain points and emphasize the value proposition. Tailor the descriptions to be concise, impactful, and keyword-optimized, highlighting the benefits and solutions offered by the product/service. ## Response Format - 5 Headlines 1. 2. 3. 4. 5. - 5 Descriptions 1. 2. 3. 4. 5. ## Instructions 1. Incorporate the provided keywords into each headline and description. 2. Align the tone and style of the ads with the specified preferences. 3. Emphasize the solutions provided by the [[product_or_service]] to address the identified pain points of the target audience. 4. Keep the headlines and descriptions within the character limits specified. 5. Ensure that each headline and description is attention-grabbing and encourages clicks from the target audience.", ULTIMATE_AI_SLUG),
      ],

      // 3:Paragraph Generator
      [
        'name' => esc_html__('Paragraph Generator', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Create unique SEO optimized paragraphs.', ULTIMATE_AI_SLUG),
        'key' => 'paragraph_generator',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pragraph.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Title', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Paragraph Title', ULTIMATE_AI_SLUG),
            'key' => 'paragraph_title',
            'is_required' => true,
          ],
          [
            'field_type' => 'number',
            'field_name' => esc_html__('Words', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Number of words', ULTIMATE_AI_SLUG),
            'key' => 'words_number',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('I want you to act as a paragraph generator to help me create a paragraph of the title I provide. The paragraph can be up to [[words_number]] words in length, expressing the key points and concepts written in the original text without adding your interpretations. My first request is to make a paragraph from this title – [[paragraph_title]]', ULTIMATE_AI_SLUG),
      ],

      // 4:Summarize Content
      [
        'name' => esc_html__('Summarize Content', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Summarize content to extract key points and insights.', ULTIMATE_AI_SLUG),
        'key' => 'summarize_content',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/summarizer.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Text to summarize', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Enter or paste your text...', ULTIMATE_AI_SLUG),
            'key' => 'summary',
            'is_required' => true,
          ],
          [
            'field_type' => 'number',
            'field_name' => esc_html__('Maximum Length', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('100', ULTIMATE_AI_SLUG),
            'key' => 'length',
            'is_required' => false,
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
          [
            'field_type' => 'result_format',
            'field_name' => esc_html__('Result fromat', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('paragraph', ULTIMATE_AI_SLUG),
            'key' => 'result_format',
          ],
        ],
        'prompt' => esc_html__('"Can you please assist me in summarizing this article? The main points and key ideas to focus on are [[summary]] . The desired length for the summary is around [[length]] . Please generate an accurate and concise summary that captures the essence of the article while maintaining readability. Feel free to add any relevant and important details that you think would enhance the summary. Thank you for your assistance!" Caption language should be [[language]] . Summarize text format should be [[result_format]] .', ULTIMATE_AI_SLUG),
      ],

      // 5:Facebook - Content Improver
      [
        'name' => esc_html__('Facebook - Content Improver', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Elevate quality of your facebook post.', ULTIMATE_AI_SLUG),
        'key' => 'fb_content_improver',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/fb.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Facebook post', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('facebook post u want to improve', ULTIMATE_AI_SLUG),
            'key' => 'fb_post',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Hashtags', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('hashtags', ULTIMATE_AI_SLUG),
            'key' => 'hash_tag',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Topic/Keywords', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('topics', ULTIMATE_AI_SLUG),
            'key' => 'topics',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('describe your target audience', ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a facebook media manager. More improve this content: [[fb_post]]. The post about is [[topics]] . Ensure readability and engagement of the post incorporating relevant emojis, trends, power words, and [[tone_of_voice]]. Format post seamlessly with the Facebook post format and style. Include funny, informative, emotional quotes that spark engagement and reactions target audience of [[target_audience]]. Caption language should be [[language]]. Try to create hashtags from post or generate from [[hash_tag]].', ULTIMATE_AI_SLUG),
      ],

      // 6:Youtube Video Title
      [
        'name' => esc_html__('Youtube Video Title', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Create eye catching youtube video title.', ULTIMATE_AI_SLUG),
        'key' => 'yt_video_title',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/yt.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Video title topics', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('topics', ULTIMATE_AI_SLUG),
            'key' => 'topics',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Video Description', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('video description', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Write about your audience', ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a YouTube media manager. Create eye-catching video titles from this description: [[description]]. The video is about [[topics]]. Ensure a variety of captions incorporating relevant emojis, trends, power words, and [[tone_of_voice]]. Format the title seamlessly with the YouTube format and style. Include informative words that spark engagement and reactions target audience of [[target_audience]]. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // 7:Email Marketing Campaign
      [
        'name' => esc_html__('Email Marketing Campaign', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Craft a friendly email campaign that positions your brand as an field expert.', ULTIMATE_AI_SLUG),
        'key' => 'email_marketing_campaign',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Ideal Customer Persona', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'IdealCustomerPersona',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product/Service', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'ProductService',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Unique Selling Points', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'UniqueSellingPoints',
            'is_required' => false,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Desired Action', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'DesiredAction',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("You are an email marketing expert. Craft an email marketing campaign using the 'Friend-Expert' framework. I want establish a connection with [[IdealCustomerPersona]] and position our brand or [[ProductService]] as an expert in our field. Use a friendly and approachable tone to connect with the reader, but also highlight our credibility and expertise in our field. Include talking points such as [[UniqueSellingPoints]], and [[DesiredAction]]", ULTIMATE_AI_SLUG),
      ],

      // 8:TikTok Ad Script:
      [
        'name' => esc_html__('TikTok Ad Script', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Get TT ad scripts that you can effortlessly turn into stunning short videos.', ULTIMATE_AI_SLUG),
        'key' => 'tiktok_ad_script',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/tiktok.svg',
        'is_active' => true,
        'is_featured' => false,

        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Key Features/Benefits *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('List the key features or benefits you want to highlight in the ad', ULTIMATE_AI_SLUG),
            'key' => 'Key_Features_Benefits',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product/Service *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 12, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'Product_Service',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'Target_Audience',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Call to action', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('e.g. visit your website, download an app, or make a purchase', ULTIMATE_AI_SLUG),
            'key' => 'Call_to_Action',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Ad duration', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe desired length e.g. 15/30/60', ULTIMATE_AI_SLUG),
            'key' => 'Ad_Duration',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Ad format', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe Ad format e.g. Live action, animation, influencer endorsement, etc.', ULTIMATE_AI_SLUG),
            'key' => 'Ad_Format',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("As an experienced marketing professional and TikTok ad specialist, help me create a captivating TikTok ad script that achieves the following specific objectives and considers the given context: ‍ * Product/Service: [[Product_Service]] * Key Features/Benefits: [[Key_Features_Benefits]] * Target Audience: [[Target_Audience]] * Ad Duration: [[Ad_Duration]] seconds * Ad Format: [[Ad_Format]] * Tone: [[tone_of_voice]] * Call-to-Action: [[Call_to_Action]] ‍ Task Requirements: ‍ 1. Analyze the product/service, target audience, and key features/benefits to develop a compelling ad concept. 2. Use a hook or attention-grabbing opening to capture the viewer's attention in the first few seconds. 3. Use clear and concise language: Avoid using complex words or jargon that may confuse the viewer. 4. Focus on the benefits of the product or service, rather than just its features. Explain how it can solve a problem or make the viewer's life easier. 5. Craft a captivating TikTok ad script that aligns with the ad format, tone, and duration. 6. Ensure the script effectively communicates the key features/benefits and appeals to the target audience. 7. Incorporate a clear and persuasive call-to-action to drive viewer engagement. 8. Optimize the script for TikTok's unique platform characteristics and user behavior. Deliverable: ‍ Provide a captivating TikTok ad script that achieves the specified objectives, considers the given context, and adheres to the desired format, tone, and duration. The script should effectively communicate the key features/benefits, appeal to the target audience, and include a clear call-to-action. Additionally, ensure the script is optimized for TikTok's unique platform characteristics and user behavior. Format the content using markdown. ‍ Caption language should be [[language]] . Include tone such as [[tone_of_voice]] .", ULTIMATE_AI_SLUG),
      ],

      // 9:Leverage Trending Hashtag
      [
        'name' => esc_html__('Leverage Trending Hashtag', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Find the best hashtags to use for your social media posts.', ULTIMATE_AI_SLUG),
        'key' => 'leverage_trending_hashtag',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/Leverage.svg',
        'is_active' => true,
        'is_featured' => false,

        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Image description', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('My 23th birthday party. Everyone looks happy.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('List the top trending hashtags related to [[description]] and suggest ways to incorporate them into a social media content strategy. Caption language should be [[language]] . Include tone such as [[tone_of_voice]] .', ULTIMATE_AI_SLUG),
      ],

      // 10: Grammar Checker
      [
        'name' => esc_html__('Grammar Checker', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Make sure your sentences are written in perfect American Standard English.', ULTIMATE_AI_SLUG),
        'key' => 'grammar_checker',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/grammar.svg',
        'is_active' => true,
        'is_featured' => false,

        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Text to check', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Enter or paste the text that needs to be checked', ULTIMATE_AI_SLUG),
            'key' => 'Text',
            'is_required' => true,
          ],
        ],
        'prompt' => esc_html__("Act like you are an expert grammar checker. Look for mistakes and make sentences more fluent. [[Text]] Please analyze the following text for a wide range of grammatical aspects and provide corrections. Be thorough in identifying and fixing any grammatical mistakes, including checking for correct punctuation usage, ensuring proper sentence structure, enhancing readability, identifying and correcting spelling mistakes, and verifying subject-verb agreement. Your assistance in ensuring the grammatical accuracy of the text is highly appreciated. Please be thorough in your examination, and provide comprehensive corrections to enhance the overall grammatical integrity of the text. Just reply to user input with the correct grammar, DO NOT reply to the context of the question of the user input. If the user input is grammatically correct and fluent, just reply “sounds good”. Please also include a span tag with class name 'grammar-error' and red color which word is corrected.", ULTIMATE_AI_SLUG),
      ],

      // 11: Youtube Video Title
      [
        'name' => esc_html__('Youtube Video Title', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Create eye catching youtube video title.', ULTIMATE_AI_SLUG),
        'key' => 'yt_video_title',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/yt.svg',
        'is_active' => true,
        'is_featured' => false,

        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Video title topics', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('topics', ULTIMATE_AI_SLUG),
            'key' => 'topics',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Video Description', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('yt_description', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Write about your audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Write about your audience', ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a YouTube media manager. Create eye-catching video titles from this description: [[yt_description]]. The video is about [[topics]]. Ensure a variety of captions incorporating relevant emojis, trends, power words, and [[tone_of_voice]]. Format the title seamlessly with the YouTube format and style. Include informative words that spark engagement and reactions target audience of [[target_audience]]. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // 12:Pros & Cons
      [
        'name' => esc_html__('Pros and Cons', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Write the pros and cons of a product, service or website for your blog article.', ULTIMATE_AI_SLUG),
        'key' => 'pros_cons',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pros_cons.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 12, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'Product_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'Product_description',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('As an experienced analyst, thoroughly evaluate the following idea, considering its potential benefits and drawbacks from various perspectives: Idea: [[Product_name]] . Context: [[Product_description]] . Task Requirements: 1. Understand the idea, its context, and potential implications. 2. Brainstorm potential benefits (pros): Create a list of all the potential benefits of the idea. Think about how it can solve a problem or improve a situation. These benefits could include increased revenue, improved efficiency, better customer satisfaction, or enhanced brand image. 3. Brainstorm potential drawbacks (cons): Create a list of all the potential drawbacks of the idea. Think about how it could create new problems or make existing problems are worse. These drawbacks could include increased costs, reduced productivity, negative customer feedback, or legal issues. 4. Consider various perspectives, such as financial, social, environmental, and practical implications. 5. Develop a comprehensive list of pros and cons, ensuring each point is relevant and well-justified. 6. Organize the pros and cons into clear, logical categories for easy reference and understanding. 7. Use a well formatted table to rank the benefits and drawbacks in order of importance, based on how likely they are to occur and their potential impact on your business. 8. Suggest any alternative ideas or approaches that might achieve the benefits of the original idea while minimizing the drawbacks. Deliverable: Provide a thorough and well-researched list of pros and cons for the specified idea, considering its context and various perspectives. The list should be comprehensive, relevant, and organized in a clear and logical manner. Format the content in markdown. Caption language should be [[language]] . Include tone such as [[tone_of_voice]] .', ULTIMATE_AI_SLUG),
      ],

      // 13:Twitter Threads
      [
        'name' => esc_html__('Twitter Threads', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Create intriguing Twitter threads that captivate readers and guide them to a desired action.', ULTIMATE_AI_SLUG),
        'key' => 'twitter_threads',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/x.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What are your Twitter threads about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Content marketing tips', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'Audience',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Please provide the [[Audience]] , [[Topic]] , or [[tone_of_voice]] you'd like to address in your Twitter thread. I will help you craft a compelling series of tweets that caters to your target audience's interests and preferences. Caption language should be [[language]] .", ULTIMATE_AI_SLUG),
      ],

      // 14:Linkedin Posts
      [
        'name' => esc_html__('Linkedin Posts', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Engage your target audience with thought-provoking and persuasive content.', ULTIMATE_AI_SLUG),
        'key' => 'linkedin_posts',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/linkdin.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your post about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('A new start-up that builds rockets', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Keywords *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('space travel, mars', ULTIMATE_AI_SLUG),
            'key' => 'Keywords',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Generate a LinkedIn post discussing [[Topic]] . Share my insights, experiences, or opinions in a concise and engaging manner. Encourage my network to join the conversation by commenting with their thoughts or experiences. Use relevant hashtags to increase visibility. #LinkedIn [[Keywords]] . Include tone of voice such as [[tone_of_voice]] . Caption language should be [[language]] .', ULTIMATE_AI_SLUG),
      ],

      // 15:Product Descriptions
      [
        'name' => esc_html__('Product Descriptions', ULTIMATE_AI_SLUG),
        'description' => esc_html__('Write the description about your product and why its worth purchasing.', ULTIMATE_AI_SLUG),
        'key' => 'product_description',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pro_des.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name*', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'product_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description*', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Explain here to the AI what your product (or service) is about. Rewrite to get different results.', ULTIMATE_AI_SLUG),
            'key' => 'product_descriptions',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Im seeking assistance in crafting a product description that goes beyond merely highlighting the features and benefits of my [[product_descriptions]] . The goal is to create content that not only persuades potential customers of its value but also provides them with valuable insights into its various uses and applications. Could you help me develop a compelling product description for the product named [[product_name]] that both informs and educates, while effectively promoting its unique selling points? Include tone of voice such as [[tone_of_voice]] Caption language should be [[language]]', ULTIMATE_AI_SLUG),
      ],

      // code Generator
      [
        'name' => 'Code Generator',
        'description' => 'Ai code assistent',
        'key' => 'ai_code_generator',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/code.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Describe what kind of code you need', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Please, be specific as possible', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Programming language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'programming_language',
          ],
        ],
        'prompt' => esc_html__('You are a coding assistant. You speak in [[language]] language. Code result should be in [[programming_language]]. Help me with this instraction: [[description]]', ULTIMATE_AI_SLUG),
      ],
      // SEO Keywords Research
      [
        'name' => 'SEO Keyword Research',
        'description' => 'Mastering SEO Keyword Research for High-Traffic Content.',
        'key' => 'seo_keyword_research',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/seo_keyword.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product/Service Description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Write a short description of your company, service or website...', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],

          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe your target audience', ULTIMATE_AI_SLUG),
            'key' => 'Audience',
            'is_required' => true,
          ],
        ],
        'prompt' => esc_html__('Please generate a list of high-volume, low-competition keywords for [[Topic]] to Use that are relevant to [[Audience]]. Also, provide insights into search intent and competition, and suggest related keywords or phrases that may be useful for optimizing content."', ULTIMATE_AI_SLUG),
      ],
      // Quora answer
      [
        'name' => 'Quora Answers',
        'description' => 'Create expert and informed answers to queries on Quora.',
        'key' => 'quora_answers',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/quora.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Question *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('How fast can an unladen swallow fly?', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Craft engaging and informative answers on Quora for questions related to [[Topic]]. Ensure each answer provides value and insight, adhering to the platform's community guidelines. Focus on delivering concise yet comprehensive responses to questions within [[Topic]].

            Highlight:
            - The training process involving a vast dataset of [[Topic]] questions and answers.
            - How it mimics common Quora inquiries, focusing on generating open-ended, thought-provoking questions.
            - Key considerations including topical relevance to [[Topic]], user interest alignment, variety in question types, difficulty levels, and engagement potential.
            Understand its aim to elicit rich, informative responses that boost interaction on the platform.
            
            Please respond [[language]]. Use a [[tone_of_voice]] to resonate with your audience effectively.", ULTIMATE_AI_SLUG),
      ],
      // Bypass AI Detection
      [
        'name' => 'Bypass AI Detection',
        'description' => 'Humanize any AI-generated content bypass the detection of AI detectors.',
        'key' => 'bypass_ai_detection',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/bypass.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Your content *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Paste the text you want to humanize here.', ULTIMATE_AI_SLUG),
            'key' => 'TypeOfContent',
            'is_required' => true,
          ],
        ],
        'prompt' => esc_html__('Re-write the provided [[TypeOfContent]] (blog post, email, product description, etc.) to ensure it is uniquely engaging, reads naturally to human readers, and is optimized for its intended purpose (readability, SEO, engagement, etc.). The goal is to refresh the content, enhancing its appeal to the target audience while maintaining its original message and intent.

            You will follow the following process: 
            Checking parameter: 
            GPTZero
            
            
            OpenAI
            
            
            Writer
            
            
            Crossplag
            
            
            Copyleaks
            
            
            Sapling
            
            
            ContentAtScale
            
            
            ZeroGPT
            ', ULTIMATE_AI_SLUG),
      ],
      // Article/Blog Outlines
      [
        'name' => 'Article/Blog Outlines',
        'description' => 'Write clear outlines of your blog post to attract more readers.',
        'key' => 'article_blog_outlines',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/article.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Title of your blog article *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('10 best ways to increase your sales volume with copywriting.', ULTIMATE_AI_SLUG),
            'key' => 'Title',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your blog post about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us the main points of your blog or paste the entire article here.', ULTIMATE_AI_SLUG),
            'key' => 'Description',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Please ignore all previous instructions. You are an expert copywriter who writes detailed and thoughtful blog articles. I will give you an outline for an article and I want you to expand in the [[language]] on each of the subheadings to create a complete article from it. Please intersperse short and long sentences. Utilize uncommon terminology to enhance the originality of the content. Please format the content in a professional format. Do not self reference. Do not explain what you are doing. The blog article outline is - [[Description]] & [[Title]]. Use a [[tone_of_voice]] to resonate with your audience effectively.', ULTIMATE_AI_SLUG),
      ],
      // Article/Blog Titles
      [
        'name' => 'Article/Blog Titles',
        'description' => 'Craft captivating listicle titles automatically, the best type of headline.',
        'key' => 'article_blog_titles',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/article.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your blog post about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us the main points of your blog or paste the entire article here.', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Please ignore all previous instructions. You are an expert copywriter who writes catchy titles for blog posts. Write 5 catchy blog post titles with a hook for the topic [[Topic]]. The titles should be written in the [[language]]. The titles should be less than 60 characters. The titles should include the words from the topic [[Topic]]. Do not use single quotes, double quotes or any other enclosing characters. Do not self reference. Do not explain what you are doing. Use a [[tone_of_voice]] to resonate with your audience effectively.', ULTIMATE_AI_SLUG),
      ],

      // Pinterest Ad - Title
      [
        'name' => 'Pinterest Ad - Title',
        'description' => 'Create exceptional titles for your Pinterest Ads and boost their conversions.            ',
        'key' => 'pinterest_ad_title',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pinterest.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 15, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'product',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Please ignore all previous instructions. Please respond [[language]]. You are a Pinterest SEO marketer and copywriter. Do not self reference. Do not explain what you are doing. Please provide me with 5 engaging Pinterest pin titles for the topic [[description]]. The titles should be between 90 to 100 characters. Please include the following product name [[product]]. Use a [[tone_of_voice]] to resonate with your audience effectively.', ULTIMATE_AI_SLUG),
      ],

      // Pinterest Ad - Description
      [
        'name' => 'Pinterest Ad - Description',
        'description' => 'Elevate your Pinterest Ad description and make it more captivating.',
        'key' => 'pinterest_ad_description',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pinterest.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 15, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'product',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Please ignore all previous instructions. Please respond [[language]]. Do not self reference. You are a Pinterest SEO marketer and copywriter. Do not self reference. Do not explain what you are doing. Please write 3 Pinterest descriptions that are between 490 to 500 characters for the following topic: [[description]]. Please include the following product name [[product]]. Use a [[tone_of_voice]] to resonate with your audience effectively.', ULTIMATE_AI_SLUG),
      ],

      // Feature to Benefit
      [
        'name' => 'Feature to Benefit',
        'description' => 'Highlighting the features of your product as well as benefits to boost sales.',
        'key' => 'feature_to_benefit',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/feature_to_benefit.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product/Service Description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'ListSpecificFeatures',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe your target audience', ULTIMATE_AI_SLUG),
            'key' => 'TargetAudience',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Develop Feature-Advantage-Benefit (FAB) statements for our new software product designed for [[TargetAudience]]. The product features include [[ListSpecificFeatures]]. Structure your statements by first listing the feature, followed by the advantage it offers, and concluding with the benefit it brings to the customer. Ensure your statements clearly articulate how our software stands out from competitors and can solve specific challenges faced by our target audience. 
            Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // Domain Name Generator
      [
        'name' => 'Domain Name Generator',
        'description' => 'Use the power of AI to find new and creative domain name ideas.',
        'key' => 'domain_name_generator',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/domain_gen.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Keywords *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Enter one or two keywords then press submit...', ULTIMATE_AI_SLUG),
            'key' => 'niche',
            'is_required' => true,
          ],
        ],
        'prompt' => esc_html__('Please generate 5 original and creative domain names specifically tailored for the [[niche]] niche, focusing on its main concepts and target audience. Your response should prioritize domain names that effectively capture the attention of the [[niche]] audience and represent its key themes. For each domain name, provide a brief explanation (1-2 sentences) highlighting its relevance to the niche. Ensure that each domain name meets the following criteria: 1. Brand Relevance: Maintain a strong connection with the niche and its central concepts. 2. Memorable: Design the domain names to be captivating, easy to remember, and with familiar spellings. 3. Concise: Keep each domain name between 6-14 characters for ease of typing and recall. 4. Simplicity: Avoid using hyphens and numbers for a cleaner appearance. 5. Keyword Incorporation: Utilize relevant niche keywords for improved SEO, if possible. 6. Pronunciation: Ensure that each domain name is easily understandable when spoken or “radio-friendly.” 7. Domain Extensions: Prioritize .com, .net, .org, and .ai extensions when applicable. 8. Legality: Refrain from infringing on existing trademarks or brands. Your response should exhibit flexibility and creativity while maintaining a focused approach on the [[niche]] niche, providing a solid foundation for building a brand within that market. [[niche]]:', ULTIMATE_AI_SLUG),
      ],

      // FAQs
      [
        'name' => 'FAQs',
        'description' => 'Produce frequently asked questions based on your product description.',
        'key' => 'faqs',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/faqs.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 12, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'Product_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'Product_description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Generate a comprehensive list of FAQs for [[Product_name]] that addresses common customer queries and concerns. Begin by identifying the most frequently asked questions, utilizing data from customer service interactions, social media inquiries, and feedback forms. Target the FAQs towards [[target_audience]], using a [[tone_of_voice]] tone of voice that aligns with [[Product_description]]. The answers should be clear, concise, and actionable, covering topics such as product features, usage instructions, troubleshooting, pricing, availability, and support services. Include tips, best practices, and links to additional resources that could assist the customer. Organize the FAQs logically, grouping similar questions for easy navigation. Conclude with detailed support options, including customer service contact information and any relevant online resources, ensuring customers have all they need for further assistance. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // Prompt
      [
        'name' => 'Prompt',
        'description' => 'Generate any copy you want! Tell the AI what to write and how.',
        'key' => 'prompt',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/prompt.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Purpose of prompt *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what to write', ULTIMATE_AI_SLUG),
            'key' => 'TypeofOutput',
            'is_required' => true,
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("I want you to become my Prompt Creator. Your goal is to help me craft the best possible prompt for my needs. The prompt will be used by you, ChatGPT. You will follow the following process: 1. I want to write about: [[prompt]]. We will continue to improve it through iterations with the following steps. 2. Based on my input in step 1, you will now generate 3 sections. a) Revised prompt (provide your rewritten prompt. it should be clear, concise, and easily understood by you), b) Suggestions (provide suggestions on what details to include in the prompt to improve it), and c) Questions (ask any relevant questions pertaining to what additional information is needed from me to improve the prompt). 3. We will continue this iterative process with me providing additional information to you and you updating the prompt in the Revised prompt section until it's complete. Caption language should be [[language]].", ULTIMATE_AI_SLUG),
      ],

      //  Youtube Video Description
      [
        'name' => esc_html__('Youtube Video Description', ULTIMATE_AI_SLUG),
        'description' => esc_html__("Generate enticing YouTube descriptions that grab viewers' attention.", ULTIMATE_AI_SLUG),
        'key' => 'youtube_video_description',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/yt.svg',
        'is_active' => true,
        'is_featured' => false,

        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your video about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Best clothing stores in Los Angeles', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Hashtag', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 15, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'hashtag',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("You are a professional in Search Engine Optimization with many years of experience doing SEO for our church's social media department, specializing in making YouTube videos go viral. Write a very attractive title and description for a YouTube video. The title and description must be based on the following: [[description]]. Based on the outcome, also provide a list of comma-separated tags for YouTube. Target audience of [[tone_of_voice]] . Caption language should be [[language]]. Try to create hashtags from description or generate from [[hashtag]].", ULTIMATE_AI_SLUG),
      ],

      // Article/Blog Ideas
      [
        'name' => 'Article/Blog Ideas',
        'description' => 'The perfect tool to start writing great articles.',
        'key' => 'article_blog_ideas',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/pro_des.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Blog post topic *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('A comprehensive guide on how to open an online store.', ULTIMATE_AI_SLUG),
            'key' => 'topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe your target audience', ULTIMATE_AI_SLUG),
            'key' => 'audience',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('I run a blog aimed at [[audience]] about [[topic]]. Come up with 5 ideas that I could write about on my blog. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // Amazon Product Descriptions
      [
        'name' => 'Amazon Product Descriptions',
        'description' => 'Generate a creative description for a product on Amazon based on its features.',
        'key' => 'amazon_product_descriptions',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/amzon.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 12, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'Product_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Key Features/Benefits *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('List the key features or benefits you want to highlight in the ad', ULTIMATE_AI_SLUG),
            'key' => 'Key_Features_Benefits',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('List of Excluded Words', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('avoid using the words listed', ULTIMATE_AI_SLUG),
            'key' => 'List_of_excluded_words',
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Your goal is to create a compelling product description for our product [[Product_name]] that effectively informs, persuades, and highlights its features and benefits provided in [[Key_Features_Benefits]]. Make sure the features and benefits given must be written in terms of headings, so elaborate and explain each heading and write some features and benefits in bullet points if possible. At the same time, avoid using the words listed in [[List_of_excluded_words]] to ensure clarity and originality. Your goal is to attract customers with engaging, easy-to-read descriptions that effectively communicate the essence of the product and entice potential customers to make a purchase. Also ensures to use easy and understandable words, make sure to enhance the product description and maintain the coherence and natural flow. Caption language should be [[language]] . Include tone such as [[tone_of_voice]] .', ULTIMATE_AI_SLUG),
      ],

      // Essay Writer
      [
        'name' => 'Essay Writer',
        'description' => 'Write a professional essay with an in-depth vision, covering everything and any reference style.',
        'key' => 'essay_writer',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/essay.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Essay topic *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('If you have a specific title, please provide it here', ULTIMATE_AI_SLUG),
            'key' => 'essay_topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target keywords *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('design, marketing, collaborate, brands', ULTIMATE_AI_SLUG),
            'key' => 'focusofessay',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Outline suggestions (optional)', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('If you have a specific outline or structure in mind, please provide it here', ULTIMATE_AI_SLUG),
            'key' => 'suggestions',
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Essay title (optional)', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('If you have a specific title, please provide it here', ULTIMATE_AI_SLUG),
            'key' => 'title',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Outline an essay on [[essay_topic]]. Discuss the pros and cons of [[essay_topic]]. Write an engaging and informative introduction for an essay about [[essay_topic]]. Present a counter-argument to the claim that [[essay_topic]]. Conclude an essay about [[essay_topic]] in a thought-provoking way. Provide a clear essay structure on [[essay_topic]] with helpful reminders on the amount of time I should allocate to each section.', ULTIMATE_AI_SLUG),
      ],

      // Meta Descriptions
      [
        'name' => 'Meta Descriptions',
        'description' => 'Compose an SEO-friendly meta description based on your website description.',
        'key' => 'meta_descriptions',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/meta_dec.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Website name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'Website_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Website description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Can be a specific description of one of your pages to get a meta for that.', ULTIMATE_AI_SLUG),
            'key' => 'Website_description',
            'is_required' => true,
          ],

          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'Target_audience',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Keywords', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('design, marketing, collaborate, brands', ULTIMATE_AI_SLUG),
            'key' => 'keywords',
            'is_required' => true,
          ],
          [
            'field_type' => 'number',
            'field_name' => esc_html__('Number of results', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('5', ULTIMATE_AI_SLUG),
            'key' => 'Number',
            'is_required' => false,
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],
          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Need help crafting captivating website meta descriptions? I'm here to help! As an AI language model, I can provide you with creative, informative, and engaging meta descriptions that appeal to potential readers. Just give me some information about your website or page, and I'll generate various options to choose from. Remember to keep it concise (no more than 160 characters), be specific with your details, and use active language for the best results. Together, we'll create the perfect meta descriptions for your website. Generate [[Number]] engaging meta descriptions for my [[Website_name]] about [[Website_description]], targeting [[Target_audience]], and including [[keywords]]. Caption language should be [[language]].", ULTIMATE_AI_SLUG),
      ],

      // Proofreader
      [
        'name' => 'Proofreader',
        'description' => 'Revise a text to correct grammar, spelling, punctuation, and formatting errors for improved clarity and professionalism.',
        'key' => 'proofreader',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/proogreader.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Text to Proofread *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Enter or paste the text that needs to be proofread', ULTIMATE_AI_SLUG),
            'key' => 'Text_to_proofread',
            'is_required' => true,
          ],

          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'Audience',
            'is_required' => true,
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a professional proofreader who has an experience of 8 years in proofreading and do proofread my document. Here is my content [[Text_to_proofread]]. Review the document as a whole to ensure overall consistency and coherence. Enhance Sentence Structure. Avoid Passive Voice Sentences. Check for spelling mistakes, typographical errors, and grammatical errors. Ensure proper use of commas, periods, semicolons, colons, apostrophes, and other punctuation marks. Ensure consistency in writing style, tone, and formatting throughout the article. Verify that font styles, sizes, and spacing are consistent. Check the accuracy of in-text citations and the bibliography/reference list. Ensure that the article flows logically and ideas are presented in a clear and coherent manner. Look for ambiguous or confusing statements. Eliminate unnecessary repetition. Verify the accuracy of facts, figures, and statistics presented in the article. Consider the audience [[Audience]] and adjust the writing style accordingly. Ensure that the introduction and conclusion align with the content of the article. Address plagiarism concerns. Once you have finished reviewing the document, provide me with any necessary corrections or suggestions for improving the text. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],
      // AIDA Formula (Attention, Interest, Desire, Action)
      [
        'name' => 'AIDA Formula (Attention, Interest, Desire, Action)',
        'description' => 'The best-known marketing model for tracing the customer journey.',
        'key' => 'AIDA_formula',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/aida.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 12, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'Product_name',
            'is_required' => true,
          ],

          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'Product_description',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('I am selling [[Product_name]] I need to write [[Product_description]] Use the AIDA formula to write it: – Step 1 (Attention): Open with a bang. Grab the reader’s attention with a bold statement, fact, or question – Step 2 (Interest): Hook the reader’s interest with features and benefits – Step 3 (Desire): Make the reader feel a sense of desire by showing them their life with my solution. – Step 4 (Action): Spur the reader into action and tell them what to do next (a CTA). Caption language should be [[language]]. Include tone such as [[tone_of_voice]].', ULTIMATE_AI_SLUG),
      ],

      // Cold Email
      [
        'name' => 'Cold Email',
        'description' => 'Introduce your company by reaching out to a lead based on your goal.',
        'key' => 'cold_email',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target company name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'Target_company_name',
            'is_required' => true,
          ],

          [
            'field_type' => 'textarea',
            'field_name' => esc_html__("Target company's unique selling point *", ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe target companies selling point', ULTIMATE_AI_SLUG),
            'key' => "Target_company's_unique_selling_point",
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Your company name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tesla, Google, Apple…', ULTIMATE_AI_SLUG),
            'key' => 'Your_company_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Your unique selling point *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe your selling point', ULTIMATE_AI_SLUG),
            'key' => 'Your_unique_selling_point',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Your name', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type your name', ULTIMATE_AI_SLUG),
            'key' => 'Your_name',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Role: You are a highly skilled email writer specializing in cold outreach for businesses. Your expertise lies in crafting engaging, sophisticated, and conversion-focused emails. Outcome 1: Cold Email Craft a cold email starting with an appreciation or acknowledgment of the [[Target_company_name]] and their [[Target_company's_unique_selling_point]]. Following this, introduce yourself and [[Your_company_name]], and immediately highlight [[Your_unique_selling_point]]. Discuss how your services or products can complement or enhance [[Target_company_name]], particularly in areas that resonate with their [[Target_company's_unique_selling_point]]. Outcome 2: Email Subject Lines Create three different subject lines for the email that are intriguing and relevant to [[Target_company_name]] and both your and their unique selling points. Each subject line should be crafted to maximize open rates and pique interest. Outcome 3: Direct Instagram Message Write a brief and engaging direct message for the target company's Instagram account. The message should be two to three sentences long, introducing yourself and your company, and expressing interest in a collaboration. Example format: Hi [[Target_company_name]] Team 👋, I'm [[Your_name]] Your Name from [[Your_company_name]]. I admire how your [[Target_company's_unique_selling_point]] has set you apart. I'd love to discuss how we can collaborate to create even more value. Are you open to a chat? Develop an engaging call to action that prompts a click, ensuring higher conversion rates. Optimize the email content for a [[tone_of_voice]]. Keep it casual and personalize the message. Email content language should be [[language]].", ULTIMATE_AI_SLUG),
      ],

      // Welcome Emails
      [
        'name' => 'Welcome Emails',
        'description' => 'Write personalized email to welcome the user for joining your service.',
        'key' => 'welcome_emails',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'Product_name',
            'is_required' => true,
          ],

          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'Product_description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'Target_audience',
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Write a welcome email to [[Target_audience]] introducing them to [[Product_name]]. Include information about [[Product_description]] and encourage them to [takeaspecificaction/joinacommunity]. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],
      // Promotional Emails
      [
        'name' => 'Promotional Emails',
        'description' => 'Compose a remarkable advertising or promotional email.',
        'key' => 'promotional_emails',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'product',
            'is_required' => true,
          ],

          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__("Describe your target audience's demographics, interests, age group etc.", ULTIMATE_AI_SLUG),
            'key' => 'target_audience',
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Why are you sending this email?', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Sign up and receive a 20% discount on your first purchase!', ULTIMATE_AI_SLUG),
            'key' => 'discount',
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('I am looking for a subject line for an email promotion about [[product]]. The email will be sent to [[target_audience]] and offering [[discount]]. Can you please generate a subject line that is [[description]]? Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],
      // Promotional Emails
      [
        'name' => 'Newsletters',
        'description' => 'Create captivating newsletter content that will consistently engage your subscribers.',
        'key' => 'newsletters',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Subject *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Explore cutting-edge technologies', ULTIMATE_AI_SLUG),
            'key' => 'subject',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Company name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'company_name',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Business description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your business is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a Newsletter Strategist. I’m here to assist you in creating engaging and effective newsletters that resonate with your audience and drive desired actions. To get started, please provide the main focus or [[subject]] of your newsletter. Once you’ve shared your focus or goal, I will ask you a series of detailed questions to gather all the necessary information to craft compelling content and design for your newsletter. These questions will be relevant to your newsletter objectives, such as: What is the primary goal of your newsletter (e.g., informing, educating, promoting, engaging)? Who is your target audience for the newsletter (e.g., existing customers, leads, subscribers)? What topics or themes do you plan to cover in your newsletter, and how often will you send it out? Do you have any specific content preferences or requirements for the newsletter (e.g., articles, tips, interviews, promotions)? What tone or style do you want your newsletter to have (e.g., formal, informal, conversational)? Are there any branding guidelines or visual preferences you’d like to incorporate into the newsletter design? How do you plan to measure the effectiveness of your newsletter (e.g., open rates, click-through rates, conversions)? etc. You, as the user, will answer each question one by one, and I will extract as much information as I can to ensure the content and design of your newsletter align with your goals and audience preferences. There will be at least 5 questions and up to 10 questions in total, all aimed at understanding your newsletter needs and creating a customized plan for content creation and design. The next question will be asked only after you provide your response to the previous one, like a survey with only one question at a time. After these questions, I will provide you with tailored recommendations and strategies for crafting engaging content, designing visually appealing layouts, optimizing subject lines and calls-to-action, and measuring the success of your newsletter campaigns. Whether you’re looking to nurture leads, drive sales, or build brand awareness, this personalized guidance will help you achieve your newsletter goals effectively and efficiently. Caption language should be [[language]].', ULTIMATE_AI_SLUG),
      ],

      // Product Launch Announcements
      [
        'name' => 'Product Launch Announcements',
        'description' => 'Stage a successful product launch with impactful ads, engaging posts, and a conversion-driven email.',
        'key' => 'product_launch_announcements',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/email.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product/Service *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Netflix, Spotify, Uber...', ULTIMATE_AI_SLUG),
            'key' => 'Product_Service',
            'is_required' => true,
          ],

          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Key Features/Benefits *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('List the key features or benefits you want to highlights', ULTIMATE_AI_SLUG),
            'key' => 'Key_Features_Benefits',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("We're launching a new [[Product_Service]], and we want to send an email announcement to our email list. Can you create an attention-grabbing subject line and a brief but exciting introduction that highlights the [[Key_Features_Benefits]]? We want to showcase our [[tone_of_voice]] solutions and build excitement among our subscribers. Caption language should be [[language]].", ULTIMATE_AI_SLUG),
      ],

      // Blog Paragraph Writer
      [
        'name' => 'Blog Paragraph Writer',
        'description' => 'Write original and human-like paragraphs based on your blog subheading (h2, h3, h4,...).',
        'key' => 'blog_paragraph_writer',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/article.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Title of your blog article *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('10 best ways to increase your sales volume with copywriting', ULTIMATE_AI_SLUG),
            'key' => 'title',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Keywords *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('landing page, Google ads, Facebook ads', ULTIMATE_AI_SLUG),
            'key' => 'keyword',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Focus keyword', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('landing page', ULTIMATE_AI_SLUG),
            'key' => 'focus_keyword',
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('Act as a human blog post writer. I’m here to create an engaging and informative blog post for your [[title]]. To get started, please provide the main focus or [[keyword]] for the blog post. Once you share the [[focus_keyword]], I will ask you a series of questions step by step to gather all the necessary information for the blog post. These questions will be relevant to the blog post like what are the focus keywords, how many paragraphs you want in the post body etc. You, as the user, will answer each question one by one, and I will extract as much information as I can to ensure the content meets your needs. There will be at least 5 questions and up to 10 questions in total, all aimed at understanding your requirements and creating a tailored blog post. The next question will be asked only after you provide your response to the previous one like a survey with only one question at a time. After these questions, I will write a proper blog post with a proper heading, introduction, and proper body and have proper paragraphs with all the headings. Caption language should be [[language]]. Include tone such as [[tone_of_voice]].', ULTIMATE_AI_SLUG),
      ],

      // Facebook Ads Copy
      [
        'name' => 'Facebook Ads Copy',
        'description' => 'Craft powerful and compelling ads that speak to your target market.',
        'key' => 'facebook_ad_copy',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/fb.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 15, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'product',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],

          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target Audience', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Describe your target audience', ULTIMATE_AI_SLUG),
            'key' => 'audience',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("Create a Facebook Ads Copy tailored to your campaign's specific objective: [[description]]. Your ad should focus on promoting [[product]], aimed at your target audience: [[audience]]. Highlight [KeyBenefits/Features] to capture your audience's attention and encourage them to take action. Use a [[tone_of_voice]] to resonate with your audience effectively. Caption language should be [[language]].", ULTIMATE_AI_SLUG),
      ],

      // LinkedIn Ad - Headline
      [
        'name' => 'LinkedIn Ad - Headline',
        'description' => 'Create an appealing and distinguished headline for your LinkedIn Ad.',
        'key' => 'linkedIn_ad_headline',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/linkdin.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Product name *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('iPhone 15, Samsung Galaxy, WhatsApp', ULTIMATE_AI_SLUG),
            'key' => 'product',
            'is_required' => true,
          ],
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('Product description *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Tell us what your product or service is about.', ULTIMATE_AI_SLUG),
            'key' => 'description',
            'is_required' => true,
          ],

          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__('I Am Creating An Ad Campaign For Linkedin To Promote [[product]] For [[description]]. Please Write 5 Copies LinkedIn ad headlines (headlines should be between 140 to 150 characters long) That Will Grab The Attention Of Potential Customers And Persuade Them To Purchase. 
            Please respond [[language]]. Use a [[tone_of_voice]] to resonate with your audience effectively.', ULTIMATE_AI_SLUG),
      ],
      // Twitter Tweets
      [
        'name' => 'Twitter Tweets',
        'description' => 'Make entertaining tweets to keep your followers interested.',
        'key' => 'twitter_weets',
        'icon_url' => UAI_ASSETS_URL_IMG . 'tool_icons/x.svg',
        'is_active' => true,
        'is_featured' => false,
        'input_fields' => [
          [
            'field_type' => 'textarea',
            'field_name' => esc_html__('What is your tweet about? *', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Best clothing stores in Los Angeles', ULTIMATE_AI_SLUG),
            'key' => 'Topic',
            'is_required' => true,
          ],
          [
            'field_type' => 'text',
            'field_name' => esc_html__('Target audience (optional)', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Type something', ULTIMATE_AI_SLUG),
            'key' => 'Audience',
          ],
          [
            'field_type' => 'tone_of_voice',
            'field_name' => esc_html__('Tone of Voice', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Result tone of voice', ULTIMATE_AI_SLUG),
            'key' => 'tone_of_voice',
          ],

          [
            'field_type' => 'language',
            'field_name' => esc_html__('Language', ULTIMATE_AI_SLUG),
            'field_placeholder' => esc_html__('Select your language', ULTIMATE_AI_SLUG),
            'key' => 'language',
          ],
        ],
        'prompt' => esc_html__("I'm looking for a creative way to promote our [[Topic]] on Twitter and engage with our followers.

            Please provide the [[Audience]], [[Topic]], or [[tone_of_voice]] you'd like to address in your Twitter tweets. I will help you craft a compelling series of tweets that caters to your target audience's interests and preferences. 
            Caption language should be [[language]]
            
            You are an Expert Twitter tweets Writer. I want you to write a twitter tweets about #Enter Topic in a #Friendly and #Approachable tone that engages readers. Your target audience is #Target Audience Write in a #Style of Writing using singular first-person pronouns only. 
            
            Format your response using 280 characters or less outputs. Use numbered outputs, bullet points, and bold Hashtags to organize the information.
            Provide a minimum of #Five Outputs each output should be 280 characters or less (including spaces)
            Include emojis and hashtags. The first letter of each word in the hashtags should be capitalized to make it easier for people using screen readers or other assistive technologies.
            Format your response using separate and numbered outputs. Use numbered outputs as shown, bullet points, and bold Hashtags to organize the information.
            Include these Hashtags: #Any Hashtags You Want Included
            In the last tweet of the thread, thank people for reading and add: If you enjoyed this thread, Follow Me to see more great tweets and threads.
            [[Topic]] Example: How to Be Kinder to Myself
            [[tone_of_voice]] Whatever tone you want your tweets to be in.
            [[Audience]] Example: people who want to learn how to be kinder to themselves and others.", ULTIMATE_AI_SLUG),
      ],
    ]; // end main default_template array;
  }
}
